#include <iostream>
#include <vector>
#include <queue>
#include <map>

using namespace std;

vector<pair<int, char> > BFS(vector<pair<int, char> > adj[], int n, int s) {
    vector<bool> visited(n, 0);
    vector<pair<int, char> > prev(n, pair<int, char>(-1, 'A'));
    queue<int> q;
    
    int x;
    char y;
    
    q.push(s);
    visited[s] = true;
    
    while (!q.empty()) {
        s = q.front();
        q.pop();
        
        for (int i = 0; i < adj[s].size(); ++i) {
            x = adj[s][i].first;
            y = adj[s][i].second;
            
            if (!visited[x]) {
                q.push(x);
                visited[x] = true;
                prev[x] = make_pair(s, y);
            }
        }
    }
    
    return prev;
}

bool recPath(vector<pair<int, char> > adj[], int n, int s, int e) {
    map<char, int> m;
    
    vector<pair<int, char> > prev = BFS(adj, n, s);
    
    for (int i = e; i != -1; i = prev[i].first) {
        ++m[prev[i].second];
    }
    
    if (m['S'] == m['I'] && m['I'] == m['O']) {
        return true;
    }
    
    return false;
}

int main() {
    int n, u, v, res = 0;
    char c;
    
    cin >> n;
    
    vector<pair<int, char> > adj[n];
    
    for (int i = 0; i < n - 1; ++i) {
        cin >> u >> v >> c;
        
        adj[u - 1].emplace_back(make_pair(v - 1, c));
        adj[v - 1].emplace_back(make_pair(u - 1, c));
    }
    
    for (int i = 0; i < n - 1; ++i) {
        for (int j = i + 1; j < n; ++j) {
            res += recPath(adj, n, i, j);
        }
    }
    
    cout << res;
}